// ShareRecord.cpp : implementation file
//

#include "stdafx.h"
#include "MultiRecoderDemo.h"
#include "ShareRecord.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "MultiRecoderDemoDlg.h"

#include "LivePropertyDlg.h"

/////////////////////////////////////////////////////////////////////////////
// CShareRecord dialog


CShareRecord::CShareRecord(CWnd* pParent /*=NULL*/)
	: CDialog(CShareRecord::IDD, pParent)
{
	//{{AFX_DATA_INIT(CShareRecord)
	//}}AFX_DATA_INIT
}


void CShareRecord::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CShareRecord)
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH, m_editShareRecordPh);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CShareRecord, CDialog)
	//{{AFX_MSG_MAP(CShareRecord)
	ON_BN_CLICKED(IDC_BUTTON_OK, OnButtonOk)
	ON_BN_CLICKED(IDC_BUTTON_NO, OnButtonNo)
	ON_BN_CLICKED(IDC_BUTTON, OnButton)
	ON_CBN_SELCHANGE(IDC_COMBO_STANDARD, OnSelchangeComboStandard)
	ON_CBN_SELCHANGE(IDC_COMBO_RECORDMODE, OnSelchangeComboRecordmode)
	ON_BN_CLICKED(IDC_CHECK_GPU, OnCheckGpu)
	ON_BN_CLICKED(IDC_CHECK_DEINTERLACE, OnCheckDeinterlace)
	ON_CBN_SELCHANGE(IDC_COMBO_FRAMERATE, OnSelchangeComboFramerate)
	ON_CBN_SELCHANGE(IDC_COMBO_AUDIO_FORMAT, OnSelchangeComboAudioFormat)
	ON_CBN_SELCHANGE(IDC_COMBO_VIDEO_RESOLUTION, OnSelchangeComboVideoResolution)
	ON_CBN_SELCHANGE(IDC_COMBO_BITRATE, OnSelchangeComboBitrate)
	ON_CBN_SELCHANGE(IDC_COMBO_QUALITY, OnSelchangeComboQuality)
	ON_CBN_SELCHANGE(IDC_COMBO_GOP, OnSelchangeComboGop)
	ON_CBN_SELCHANGE(IDC_COMBO_SCALE, OnSelchangeComboScale)
	ON_BN_CLICKED(IDC_RADIO_AVI, OnRadioAvi)
	ON_BN_CLICKED(IDC_RADIO_MP4, OnRadioMp4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CShareRecord message handlers

VOID CShareRecord::SetShareFormatChangedOutput() {

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->SetShareFormatChangedOutput_CShareRecord();
}

BOOL CShareRecord::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	// SETTING SHARE RECORD PATH
	//
	CString strFullPathName;

	strFullPathName =  pMainDlg->m_strShareRecordPath;

	m_editShareRecordPh.SetWindowText( strFullPathName );


	// SETTING SHARE RECORD FORMAT
	//
	if ( pMainDlg->m_nShareRecordFormat == 0 ) { CheckDlgButton( IDC_RADIO_AVI, BST_CHECKED ); }

	if ( pMainDlg->m_nShareRecordFormat == 1 ) { CheckDlgButton( IDC_RADIO_MP4, BST_CHECKED ); }

	// SETTING SHARE RECORD STANDARD
	//
	if ( pMainDlg->m_nShareRecordStandard == 0 ) { ((CComboBox*)GetDlgItem( IDC_COMBO_STANDARD ))->SetCurSel( 0 ); }

	if ( pMainDlg->m_nShareRecordStandard == 1 ) { ((CComboBox*)GetDlgItem( IDC_COMBO_STANDARD ))->SetCurSel( 1 ); }

	// SETTING SHARE RECORD FRAMERATE
	//
	((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->SetCurSel( pMainDlg->m_nShareRecordFrameRatePos );

	// SETTING SHARE RECORD FRAMERATE
	//		
	((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_RESOLUTION ))->SetCurSel( pMainDlg->m_nShareRecordResolutionPos );
	
	OnSelchangeComboStandard();

	// SETTING SHARE  RECORD VIDEO FRAMERATE
	//
	((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_FORMAT ))->SetCurSel( 0 );

	// SETTING SHARE RECORD AUDIO FRAMERATE
	//
	((CComboBox*)GetDlgItem( IDC_COMBO_AUDIO_FORMAT ))->SetCurSel( pMainDlg->m_nShareRecordAudioFormat );


	// SETTING GOP
	//
	for ( ULONG i = 1; i <= 255; i++ ) {

		CHAR psz[ 16 ]; 
			
		sprintf( psz, "%3d", i );

		((CComboBox*)GetDlgItem( IDC_COMBO_GOP ))->AddString( psz );

		((CComboBox*)GetDlgItem( IDC_COMBO_GOP ))->SetCurSel( pMainDlg->m_nShareRecordGOP );
	}

	// SETTING SHARE RECORD BITRATES
	//
	((CComboBox*)GetDlgItem( IDC_COMBO_BITRATE ))->SetCurSel( pMainDlg->m_nShareRecordBiteRate );

	// SETTING SHARE RECORD QUALITY
	//	
	((CComboBox*)GetDlgItem( IDC_COMBO_QUALITY ))->SetCurSel( pMainDlg->m_nShareRecordQuality );

	// SETTING SHARE RECORD MODE
	//		
	((CComboBox*)GetDlgItem( IDC_COMBO_RECORDMODE ))->SetCurSel( pMainDlg->m_nShareRecordMode );

	OnSelchangeComboRecordmode();

	// SETTING SHARE RECORD SCALE
	//
	((CComboBox*)GetDlgItem( IDC_COMBO_SCALE ))->SetCurSel( pMainDlg->m_nShareRecordScale );

	// SETTING SHARE GPU & DEINTERLACE
	//
	((CButton*)GetDlgItem( IDC_CHECK_GPU ))->SetCheck( pMainDlg->m_bShareRecordSupportGPU );

	((CButton*)GetDlgItem( IDC_COMBO_SCALE ))->SetCheck( pMainDlg->m_bShareRecordAutoDeinterlace );
	
	// DISABLE CONTROLER
	//
	((CButton*)GetDlgItem( IDC_CHECK_DEINTERLACE ))->ShowWindow( FALSE );
	((CButton*)GetDlgItem( IDC_COMBO_SCALE ))->ShowWindow( FALSE );
	((CButton*)GetDlgItem( IDC_STATIC_SCALE ))->ShowWindow( FALSE );

	((CButton*)GetDlgItem( IDC_STATIC_AUDIO_FORMAT ))->ShowWindow( FALSE );	
	((CButton*)GetDlgItem( IDC_COMBO_AUDIO_FORMAT ))->ShowWindow( FALSE );

	SetShareFormatChangedOutput();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CShareRecord::OnButtonOk() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CShareRecord* m_pMainParent = (CShareRecord*)this;

	m_pMainParent->SendMessage( WM_CLOSE );
	
	//m_pMainParent->DestroyWindow();

	CDialog::OnOK();
}

void CShareRecord::OnButtonNo() 
{
	// TODO: Add your control notification handler code here
	
	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CShareRecord* m_pMainParent = (CShareRecord*)this;

	m_pMainParent->SendMessage( WM_CLOSE );
	
	//m_pMainParent->DestroyWindow();

	CDialog::OnOK();
}

void CShareRecord::OnButton() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

    char szPath[ 1024 ];     

    CString str;

    ZeroMemory( szPath, sizeof(szPath) );   

    BROWSEINFO bi;
    bi.hwndOwner		= m_hWnd;
    bi.pidlRoot			= NULL;   
    bi.pszDisplayName	= szPath;   
    bi.lpszTitle		= "Select Record Path:";   
    bi.ulFlags			= 0;   
    bi.lpfn				= NULL;   
    bi.lParam			= 0;   
    bi.iImage			= 0;   
    
    LPITEMIDLIST lp		= SHBrowseForFolder(&bi);   

    if( lp && SHGetPathFromIDList( lp, szPath ) ) {

        str.Format( "%s",  szPath );

		pMainDlg->m_strShareRecordPath = str;

		m_editShareRecordPh.SetWindowText( (LPCTSTR)pMainDlg->m_strShareRecordPath ); 
    }
    else {

		AfxMessageBox("The Direction Not Exist");   	
	} 
}

void CShareRecord::OnSelchangeComboStandard() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->m_nShareRecordStandard = ((CComboBox*)GetDlgItem( IDC_COMBO_STANDARD ))->GetCurSel();

	ULONG i = pMainDlg->m_nShareRecordStandard;


	if ( i == 0 ) {
		
		ULONG j = pMainDlg->m_nShareRecordResolutionPos;
	
		((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_RESOLUTION ))->ResetContent();
		
		((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_RESOLUTION ))->AddString( "1920x1080" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_RESOLUTION ))->AddString( "1280x720" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_RESOLUTION ))->AddString( "720x480" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_RESOLUTION ))->SetCurSel( j );
	}

	if ( i == 1 ) {
		
		ULONG j = pMainDlg->m_nShareRecordResolutionPos;
		
		((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_RESOLUTION ))->ResetContent();
		
		((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_RESOLUTION ))->AddString( "1920x1080" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_RESOLUTION ))->AddString( "1280x720" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_RESOLUTION ))->AddString( "720x576" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_RESOLUTION ))->SetCurSel( j );
	}


	if ( i == 0 ) {
		
		ULONG r = pMainDlg->m_nShareRecordResolutionPos;
		
		ULONG j = pMainDlg->m_nShareRecordFrameRatePos;
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->ResetContent();
		
		//((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( (r == 0) ? "30.000" : "60.000" );

		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( "60.000" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( "30.000" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( "15.000" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( " 7.500" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( " 3.750" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->SetCurSel( j );	
	}

	if ( i == 1 ) {
		
		ULONG r = pMainDlg->m_nShareRecordResolutionPos;
		
		ULONG j = pMainDlg->m_nShareRecordFrameRatePos;
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->ResetContent();
		
		//((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( (r == 0) ? "25.000" : "50.000" );

		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( "50.000" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( "25.000" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( "12.500" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( " 6.250" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->AddString( " 3.125" );
		
		((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->SetCurSel( j );	
	}

	SetShareFormatChangedOutput();
}

void CShareRecord::OnSelchangeComboRecordmode() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->m_nShareRecordMode = ((CComboBox*)GetDlgItem( IDC_COMBO_RECORDMODE ))->GetCurSel();

	ULONG i = pMainDlg->m_nShareRecordMode;

	if ( i == 0 ) { ((CComboBox*)GetDlgItem( IDC_COMBO_BITRATE ))->EnableWindow( FALSE ); }

	if ( i == 0 ) { ((CComboBox*)GetDlgItem( IDC_COMBO_QUALITY ))->EnableWindow( TRUE  ); }

	if ( i == 1 ) { ((CComboBox*)GetDlgItem( IDC_COMBO_BITRATE ))->EnableWindow( TRUE  ); }

	if ( i == 1 ) { ((CComboBox*)GetDlgItem( IDC_COMBO_QUALITY ))->EnableWindow( FALSE ); }	

	SetShareFormatChangedOutput();
}

void CShareRecord::OnCheckGpu() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->m_bShareRecordSupportGPU = ((CButton*)GetDlgItem( IDC_CHECK_GPU ))->GetCheck();

	ULONG i = pMainDlg->m_bShareRecordSupportGPU;

	SetShareFormatChangedOutput();
}

void CShareRecord::OnCheckDeinterlace() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->m_bShareRecordAutoDeinterlace = ((CButton*)GetDlgItem( IDC_CHECK_DEINTERLACE ))->GetCheck();

	ULONG i = pMainDlg->m_bShareRecordAutoDeinterlace;

	SetShareFormatChangedOutput();
}

void CShareRecord::OnSelchangeComboFramerate() 
{
	// TODO: Add your control notification handler code here
	
	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->m_nShareRecordFrameRatePos = ((CComboBox*)GetDlgItem( IDC_COMBO_FRAMERATE ))->GetCurSel();

	ULONG i = pMainDlg->m_nShareRecordFrameRatePos;	

	SetShareFormatChangedOutput();
}


void CShareRecord::OnSelchangeComboAudioFormat() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->m_nShareRecordAudioFormat = ((CComboBox*)GetDlgItem( IDC_COMBO_AUDIO_FORMAT ))->GetCurSel();

	ULONG i = pMainDlg->m_nShareRecordAudioFormat;	

	SetShareFormatChangedOutput();
}

void CShareRecord::OnSelchangeComboVideoResolution() 
{
	// TODO: Add your control notification handler code here
	
	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->m_nShareRecordResolutionPos = ((CComboBox*)GetDlgItem( IDC_COMBO_VIDEO_RESOLUTION ))->GetCurSel();

	ULONG i = pMainDlg->m_nShareRecordResolutionPos;
	
	SetShareFormatChangedOutput();
}

void CShareRecord::OnSelchangeComboBitrate() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->m_nShareRecordBiteRate = ((CComboBox*)GetDlgItem( IDC_COMBO_BITRATE ))->GetCurSel();

	ULONG i = pMainDlg->m_nShareRecordBiteRate;	

	SetShareFormatChangedOutput();
}

void CShareRecord::OnSelchangeComboQuality() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->m_nShareRecordQuality = ((CComboBox*)GetDlgItem( IDC_COMBO_QUALITY ))->GetCurSel();

	ULONG i = pMainDlg->m_nShareRecordQuality;	

	SetShareFormatChangedOutput();
}

void CShareRecord::OnSelchangeComboGop() 
{
	// TODO: Add your control notification handler code here
	
	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->m_nShareRecordGOP = ((CComboBox*)GetDlgItem( IDC_COMBO_GOP ))->GetCurSel();

	ULONG i = pMainDlg->m_nShareRecordGOP;	
	
	SetShareFormatChangedOutput();
}

void CShareRecord::OnSelchangeComboScale() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->m_nShareRecordScale = ((CComboBox*)GetDlgItem( IDC_COMBO_SCALE ))->GetCurSel();

	ULONG i = pMainDlg->m_nShareRecordScale;
	
	SetShareFormatChangedOutput();
}

void CShareRecord::OnRadioAvi() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->m_nShareRecordAudioFormat = 0x00000000;

	SetShareFormatChangedOutput();
}

void CShareRecord::OnRadioMp4() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	pMainDlg->m_nShareRecordAudioFormat = 0x00000001;
	
	SetShareFormatChangedOutput();
}
