﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Runtime.InteropServices;

using QCAP.NET;

namespace RtspServerDemo
{
    public partial class Form1 : Form
    {
        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        public static extern void OutputDebugString(string message);        

        public Form1()
        {
            InitializeComponent();
        }

        public uint i = 0;

        public string m_strCurrentDir = "";

        public bool m_bIsMaximizedForm = false;

        public bool[] m_bIsMaximizedChannelWindow = new bool[4];

        public bool[] m_bNoSignal = new bool[4];

        public string[] m_strFormatChangedOutput = new string[4];

        public bool[] m_bShareRecordCH = new bool[4];

        public bool m_bIsShareRecord = false;

        public bool m_bSupportGPU = false;        

        public bool m_bCheckedAVI = true;

        public bool m_bCheckedMP4 = false;

        public bool m_bIsStreaming = false;

        public uint m_nVideoWidth = 1920;

        public uint m_nVideoHeight = 1080;

        public uint m_nVideoFrameRate = 60;

        public string m_strAviName;

        public string m_strFormatChangedOutput1 = " INFO :  . . .", m_strFormatChangedOutput2 = " INFO :  . . .", m_strFormatChangedOutput3 = " INFO :  . . .", m_strFormatChangedOutput4 = " INFO :  . . .";

        public MyVideoInputDlg m_cVideoInputDlg;

        public MyAudioInputDlg m_cAudioInputDlg;

        // FOURCC MARCO
        //
        uint MAKEFOURCC(uint ch0, uint ch1, uint ch2, uint ch3)
        {
            return ((uint)(byte)(ch0) | ((uint)(byte)(ch1) << 8) | ((uint)(byte)(ch2) << 16) | ((uint)(byte)(ch3) << 24));
        }

        // CALLBACK FUNCTION
        //        
        EXPORTS.PF_FORMAT_CHANGED_CALLBACK m_pFormatChangedCB;

        EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK m_pNoSignalDetectedCB;

        EXPORTS.PF_SIGNAL_REMOVED_CALLBACK m_pSignalRemovedCB;

        EXPORTS.PF_VIDEO_PREVIEW_CALLBACK m_pPreviewVideoCB;

        EXPORTS.PF_AUDIO_PREVIEW_CALLBACK m_pPreviewAudioCB;

        string m_strChipName = "SA7160 PCI";

        // DEVICE PROPERTY
        //
        public uint[] m_hCapDev = new uint[4];                         // STREAM CAPTURE DEVICE        

        public uint m_hRtspCapDev = 0;                                    // RTSP STREAM CAPTURE DEVICE

        //  FORMAT CHANGED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_format_changed(uint pDevice, uint nVideoInput, uint nAudioInput, uint nVideoWidth, uint nVideoHeight, uint bVideoIsInterleaved, uint nVideoFrameRate, uint nAudioChannels, uint nAudioBitsPerSample, uint nAudioSampleFrequency, uint pUserData)
        {
            uint nCH = pUserData;

            // OUTPUT FORMAT CHANGED MESSAGE
            //
            string strOutput = "CH" + (nCH + 1).ToString() + " -> FORMAT CHANGED : pDevice : " + pDevice.ToString() + " , " + "nVideoInput : " + nVideoInput.ToString() + " , " +

                                        "nAudioInput : " + nAudioInput.ToString() + " , " + "nVideoWidth : " + nVideoWidth.ToString() + " , " +

                                        "nVideoHeight : " + nVideoHeight.ToString() + " , " + "bVideoIsInterleaved : " + bVideoIsInterleaved.ToString() + " , " +

                                        "nVideoFrameRate : " + nVideoFrameRate.ToString() + " , " + "nAudioChannels : " + nAudioChannels.ToString() + " , " +

                                        "nAudioBitsPerSample : " + nAudioBitsPerSample.ToString() + " , " + "nAudioSampleFrequency : " + nAudioSampleFrequency.ToString() + " , " +

                                        "pUserData : " + pUserData.ToString() + " \n";

            OutputDebugString(strOutput);

            m_nVideoWidth = nVideoWidth;

            m_nVideoHeight = nVideoHeight;

            m_nVideoFrameRate = nVideoFrameRate;

            uint nVH = 0;

            string strFrameType = " P ";

            string strVideoInput = ""; 
                
            string strAudioInput = "";

            if (nVideoInput == 0) { strVideoInput = "COMPOSITE"; } if (nVideoInput == 1) { strVideoInput = "SVIDEO"; } if (nVideoInput == 2) { strVideoInput = "HDMI"; }

            if (nVideoInput == 3) { strVideoInput = "DVI_D"; } if (nVideoInput == 4) { strVideoInput = "COMPONENTS (YCBCR)"; } if (nVideoInput == 5) { strVideoInput = "DVI_A (RGB / VGA)"; }

            if (nVideoInput == 6) { strVideoInput = "SDI"; } if (nVideoInput == 7) { strVideoInput = "AUTO"; }

            if (nAudioInput == 0) { strAudioInput = "EMBEDDED_AUDIO"; } if (nAudioInput == 1) { strAudioInput = "LINE_IN"; }

            if (bVideoIsInterleaved == 1) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

            if (bVideoIsInterleaved == 1) { strFrameType = " I "; } else { strFrameType = " P "; }

            /*
            m_strFormatChangedOutput[nCH] = @" INFO : " + nVideoWidth.ToString() + " x " + nVH.ToString() + strFrameType + " @" + nVideoFrameRate.ToString() +

                " FPS , " + nAudioChannels.ToString() + " CH x " + nAudioBitsPerSample.ToString() + " BITS x " + nAudioSampleFrequency.ToString() + " HZ , " +

                " VIDEO INPUT : " + strVideoInput + " , " + " AUDIO INPUT : " + strAudioInput + " \n";
            */

            m_strFormatChangedOutput[nCH] = @"INPUT : " + strVideoInput + " , " + nVideoWidth.ToString() + " x " + nVH.ToString() + strFrameType + " @" + nVideoFrameRate.ToString() + " FPS ";

            // NO SIGNAL
            //       
            if (nVideoWidth == 0 && nVideoHeight == 0 && nVideoFrameRate == 0 && nAudioChannels == 0 && nAudioBitsPerSample == 0 && nAudioSampleFrequency == 0)
            {
                m_bNoSignal[nCH] = true;
            }
            else
            {
                m_bNoSignal[nCH] = false;
            }

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // PREVIEW VIDEO CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_preview_video_buffer(uint pDevice, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            uint nCH = pUserData;

            //string strOutput = "CH" + (nCH + 1).ToString() +  " : on_process_preview_video_buffer => pDevice : " + pDevice.ToString() + " , dSampleTime : " + dSampleTime.ToString() + " , pFrameBuffer : " + pFrameBuffer.ToString() + " , nFrameBufferLen : " + nFrameBufferLen.ToString() + " , pUserData : " + pUserData.ToString() + " \n";

            //OutputDebugString(strOutput);

            if (m_bIsShareRecord && m_bShareRecordCH[nCH])
            {
                EXPORTS.QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, MAKEFOURCC('Y', 'U', 'Y', '2'), m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen);
            }

            if (m_bIsStreaming && m_hRtspCapDev != 0)
            {
                EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, MAKEFOURCC('Y', 'U', 'Y', '2'), m_nVideoWidth, m_nVideoHeight, pFrameBuffer, nFrameBufferLen);
            }

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // PREVIEW AUDIO CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_preview_audio_buffer(uint pDevice, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            uint nCH = pUserData;

            //string strOutput = "CH" + (nCH + 1).ToString() + " : on_process_preview_audio_buffer => pDevice : " + pDevice.ToString() + " , dSampleTime : " + dSampleTime.ToString() + " , pFrameBuffer : " + pFrameBuffer.ToString() + " , nFrameBufferLen : " + nFrameBufferLen.ToString() + " , pUserData : " + pUserData.ToString() + " \n";

            //OutputDebugString(strOutput);

            if (m_bIsShareRecord && m_bShareRecordCH[nCH])
            {
                EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, pFrameBuffer, nFrameBufferLen);
            }

            if (m_bIsStreaming && m_hRtspCapDev != 0)
            {
                EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER(m_hRtspCapDev, nCH, pFrameBuffer, nFrameBufferLen);
            }

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // NO SIGNAL DETEACTED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_no_signal_detected(uint pDevice, uint nVideoInput, uint nAudioInput, uint pUserData)
        {
            uint nCH = pUserData;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // SIGNAL REMOVED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_signal_removed(uint pDevice, uint nVideoInput, uint nAudioInput, uint pUserData)
        {
            uint nCH = pUserData;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // GET CURRENT DIRECTORY
            //
            m_strCurrentDir = Directory.GetCurrentDirectory();

            m_strAviName = m_strCurrentDir + "\\_SHARE_RECORD.AVI";

            textBoxRecordAVI1_1.Text = m_strAviName;

            m_btnShareRecordStart1.Enabled = true;

            m_btnShareRecordStop1.Enabled = false;

            m_btnStartStreaming.Enabled = true;

            m_btnStopStreaming.Enabled = false;

            m_cVideoInputDlg = new MyVideoInputDlg();

            m_cVideoInputDlg.m_pMainForm = this;

            m_cVideoInputDlg.Hide();

            m_cAudioInputDlg = new MyAudioInputDlg();

            m_cAudioInputDlg.m_pMainForm = this;

            m_cAudioInputDlg.Hide();

            m_btnShareSwitchCH01.Checked = true; m_btnShareSwitchCH02.Checked = false; m_btnShareSwitchCH03.Checked = false; m_btnShareSwitchCH04.Checked = false;

            m_bShareRecordCH[0] = true; m_bShareRecordCH[1] = false; m_bShareRecordCH[2] = false; m_bShareRecordCH[3] = false;

            HwInitialize();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            timerCheckSignal.Enabled = false;

            EXPORTS.QCAP_STOP_SHARE_RECORD(0);

            HwUnInitialize();
        }

        public bool HwInitialize()
        {
            for (i = 0; i < 4; i++) { m_hCapDev[i] = 0x00000000; }            

            for (i = 0; i < 4; i++) { m_bNoSignal[i] = true; }

            for (i = 0; i < 4; i++) { m_strFormatChangedOutput[i] = ""; }

            // CREATE RTSP SERVER
            //
            String strAccount = "root";

            String strPassword = "root";

            EXPORTS.QCAP_CREATE_BROADCAST_RTSP_SERVER(0, 4, ref m_hRtspCapDev, ref strAccount, ref strPassword, 554);

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), m_nVideoWidth, m_nVideoHeight, m_nVideoFrameRate, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0);

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 1, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), m_nVideoWidth, m_nVideoHeight, m_nVideoFrameRate, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0);

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), m_nVideoWidth, m_nVideoHeight, m_nVideoFrameRate, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0);

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 3, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), m_nVideoWidth, m_nVideoHeight, m_nVideoFrameRate, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0);

            EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM, 2, 16, 48000, 100);

            EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 1, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM, 2, 16, 48000, 100);

            EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM, 2, 16, 48000, 100);

            EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 3, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM, 2, 16, 48000, 100);       

            // CREATE CAPTURE DEVICE            
            //
            EXPORTS.QCAP_CREATE(ref m_strChipName, 0, (uint)PreviewWindow1.Handle.ToInt32(), ref m_hCapDev[0], 1);

            EXPORTS.QCAP_CREATE(ref m_strChipName, 1, (uint)PreviewWindow2.Handle.ToInt32(), ref m_hCapDev[1], 1);

            EXPORTS.QCAP_CREATE(ref m_strChipName, 2, (uint)PreviewWindow3.Handle.ToInt32(), ref m_hCapDev[2], 1);

            EXPORTS.QCAP_CREATE(ref m_strChipName, 3, (uint)PreviewWindow4.Handle.ToInt32(), ref m_hCapDev[3], 1);            

            // REGISTER FORMAT CHANGED CALLBACK FUNCTION
            // 
            m_pFormatChangedCB = new EXPORTS.PF_FORMAT_CHANGED_CALLBACK(on_process_format_changed);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[0], m_pFormatChangedCB, 0);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[1], m_pFormatChangedCB, 1);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[2], m_pFormatChangedCB, 2);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[3], m_pFormatChangedCB, 3);

            // REGISTER PREVIEW VIDEO CALLBACK FUNCTION
            // 
            m_pPreviewVideoCB = new EXPORTS.PF_VIDEO_PREVIEW_CALLBACK(on_process_preview_video_buffer);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[0], m_pPreviewVideoCB, 0);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[1], m_pPreviewVideoCB, 1);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[2], m_pPreviewVideoCB, 2);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[3], m_pPreviewVideoCB, 3);

            // REGISTER PREVIEW AUDIO CALLBACK FUNCTION
            //
            m_pPreviewAudioCB = new EXPORTS.PF_AUDIO_PREVIEW_CALLBACK(on_process_preview_audio_buffer);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[0], m_pPreviewAudioCB, 0);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[1], m_pPreviewAudioCB, 1);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[2], m_pPreviewAudioCB, 2);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[3], m_pPreviewAudioCB, 3);

            // REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
            //
            m_pNoSignalDetectedCB = new EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK(on_process_no_signal_detected);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[0], m_pNoSignalDetectedCB, 0);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[1], m_pNoSignalDetectedCB, 1);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[2], m_pNoSignalDetectedCB, 2);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[3], m_pNoSignalDetectedCB, 3);

            // REGISTER SIGNAL REMOVED CALLBACK FUNCTION
            //
            m_pSignalRemovedCB = new EXPORTS.PF_SIGNAL_REMOVED_CALLBACK(on_process_signal_removed);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[0], m_pSignalRemovedCB, 0);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[1], m_pSignalRemovedCB, 1);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[2], m_pSignalRemovedCB, 2);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[3], m_pSignalRemovedCB, 3);

            // SET INPUT
            //
            uint nInput = (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SDI;

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[0], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[1], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[2], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[3], nInput);

            // SET DEINTERLACE
            //
            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[0], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[1], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[2], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[3], 0);

            // RUN DEVICE
            //
            EXPORTS.QCAP_RUN(m_hCapDev[0]);

            EXPORTS.QCAP_RUN(m_hCapDev[1]);

            EXPORTS.QCAP_RUN(m_hCapDev[2]);

            EXPORTS.QCAP_RUN(m_hCapDev[3]);

            timerCheckSignal.Enabled = true;

            return true;
        }

        public bool HwUnInitialize()
        {
            if (m_hRtspCapDev != 0) { EXPORTS.QCAP_DESTROY_BROADCAST_SERVER(m_hRtspCapDev); }

            if (m_hCapDev[0] != 0) { EXPORTS.QCAP_STOP(m_hCapDev[0]); EXPORTS.QCAP_DESTROY(m_hCapDev[0]); }

            if (m_hCapDev[1] != 0) { EXPORTS.QCAP_STOP(m_hCapDev[1]); EXPORTS.QCAP_DESTROY(m_hCapDev[1]); }

            if (m_hCapDev[2] != 0) { EXPORTS.QCAP_STOP(m_hCapDev[2]); EXPORTS.QCAP_DESTROY(m_hCapDev[2]); }

            if (m_hCapDev[3] != 0) { EXPORTS.QCAP_STOP(m_hCapDev[3]); EXPORTS.QCAP_DESTROY(m_hCapDev[3]); }

            return true;
        }

        private void m_btnVideoInput_Click(object sender, EventArgs e)
        {
            m_cVideoInputDlg.m_hCapDev[0] = m_hCapDev[0];

            m_cVideoInputDlg.m_hCapDev[1] = m_hCapDev[1];

            m_cVideoInputDlg.m_hCapDev[2] = m_hCapDev[2];

            m_cVideoInputDlg.m_hCapDev[3] = m_hCapDev[3];

            m_cVideoInputDlg.Show();
        }

        private void m_btnAudioInput_Click(object sender, EventArgs e)
        {
            m_cAudioInputDlg.m_hCapDev[0] = m_hCapDev[0];

            m_cAudioInputDlg.m_hCapDev[1] = m_hCapDev[1];

            m_cAudioInputDlg.m_hCapDev[2] = m_hCapDev[2];

            m_cAudioInputDlg.m_hCapDev[3] = m_hCapDev[3];

            m_cAudioInputDlg.Show();
        }

        private void m_btnShareRecordStart1_Click(object sender, EventArgs e)
        {
            m_btnShareRecordStart1.Enabled = false;

            m_btnShareRecordStop1.Enabled = true;

            m_bSupportGPU = m_checkGPU1_1.Checked;

            uint nVideoWidth = m_nVideoWidth;

            uint nVideoHeight = m_nVideoHeight;

            uint nVideoFrameRate = m_nVideoFrameRate;

            if (m_bCheckedAVI)
            {
                EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY(0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM, 2, 16, 48000, 100);
            }

            if (m_bCheckedMP4)
            {
                EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY(0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 100);
            }

            if (m_bSupportGPU)
            {
                EXPORTS.QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY(0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), nVideoWidth, nVideoHeight, nVideoFrameRate, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 4194304, 30, 0, 0, (uint)ShareWindow.Handle.ToInt32(), 1);
            }
            else
            {
                EXPORTS.QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY(0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), nVideoWidth, nVideoHeight, nVideoFrameRate, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 4194304, 30, 0, 0, (uint)ShareWindow.Handle.ToInt32(), 1);
            }

            EXPORTS.QCAP_START_SHARE_RECORD(0, ref m_strAviName);

            m_bIsShareRecord = true;
        }

        private void m_btnShareRecordStop1_Click(object sender, EventArgs e)
        {
            m_btnShareRecordStart1.Enabled = true;

            m_btnShareRecordStop1.Enabled = false;

            EXPORTS.QCAP_STOP_SHARE_RECORD(0);

            m_bIsShareRecord = false;            
        }

        private void m_btnStartStreaming_Click(object sender, EventArgs e)
        {
            m_btnStartStreaming.Enabled = false;

            m_btnStopStreaming.Enabled = true;

            if (m_hRtspCapDev != 0)
            {
                EXPORTS.QCAP_START_BROADCAST_SERVER(m_hRtspCapDev);

                m_bIsStreaming = true;
            }
        }

        private void m_btnStopStreaming_Click(object sender, EventArgs e)
        {
            m_btnStartStreaming.Enabled = true;

            m_btnStopStreaming.Enabled = false;

            if (m_hRtspCapDev != 0)
            {
                m_bIsStreaming = false;

                EXPORTS.QCAP_STOP_BROADCAST_SERVER(m_hRtspCapDev);
            }
        }

        private void m_checkGPU1_1_Click(object sender, EventArgs e)
        {
            m_btnShareRecordStop1_Click(sender, e);
        }

        private void m_checkAVI1_1_Click(object sender, EventArgs e)
        {
            m_checkAVI1_1.Checked = true;

            m_checkMP41_1.Checked = false;

            m_bCheckedAVI = true;

            m_bCheckedMP4 = false;

            m_strAviName = m_strAviName.Replace(".MP4", ".AVI");

            textBoxRecordAVI1_1.Text = m_strAviName;
        }

        private void m_checkMP41_1_Click(object sender, EventArgs e)
        {
            m_checkAVI1_1.Checked = false;

            m_checkMP41_1.Checked = true;

            m_bCheckedAVI = false;

            m_bCheckedMP4 = true;

            m_strAviName = m_strAviName.Replace(".AVI", ".MP4");

            textBoxRecordAVI1_1.Text = m_strAviName;
        }

        private void PreviewWindow1_Click(object sender, EventArgs e)
        {
            m_bShareRecordCH[0] = true; m_bShareRecordCH[1] = false; m_bShareRecordCH[2] = false; m_bShareRecordCH[3] = false;
        }        

        private void timerCheckSignal_Tick(object sender, EventArgs e)
        {
            // DISPLAY FORMAT CHANGED MESSAGE
            //
            if (m_bNoSignal[0]) { m_strFormatChangedOutput1 = " INFO :  . . ."; } else { m_strFormatChangedOutput1 = m_strFormatChangedOutput[0]; }

            if (m_bNoSignal[1]) { m_strFormatChangedOutput2 = " INFO :  . . ."; } else { m_strFormatChangedOutput2 = m_strFormatChangedOutput[1]; }

            if (m_bNoSignal[2]) { m_strFormatChangedOutput3 = " INFO :  . . ."; } else { m_strFormatChangedOutput3 = m_strFormatChangedOutput[2]; }

            if (m_bNoSignal[3]) { m_strFormatChangedOutput4 = " INFO :  . . ."; } else { m_strFormatChangedOutput4 = m_strFormatChangedOutput[3]; }

            textBox1.Text = m_strFormatChangedOutput1;

            textBox2.Text = m_strFormatChangedOutput2;

            textBox3.Text = m_strFormatChangedOutput3;

            textBox4.Text = m_strFormatChangedOutput4;
        }

        private void m_btnShareSwitchCH01_Click(object sender, EventArgs e)
        {
            m_btnShareSwitchCH01.Checked = true;

            m_btnShareSwitchCH02.Checked = false;

            m_btnShareSwitchCH03.Checked = false;

            m_btnShareSwitchCH04.Checked = false;

            m_bShareRecordCH[0] = true; m_bShareRecordCH[1] = false; m_bShareRecordCH[2] = false; m_bShareRecordCH[3] = false;
        }

        private void m_btnShareSwitchCH02_Click(object sender, EventArgs e)
        {
            m_btnShareSwitchCH01.Checked = false;

            m_btnShareSwitchCH02.Checked = true;

            m_btnShareSwitchCH03.Checked = false;

            m_btnShareSwitchCH04.Checked = false;

            m_bShareRecordCH[0] = false; m_bShareRecordCH[1] = true; m_bShareRecordCH[2] = false; m_bShareRecordCH[3] = false;
        }

        private void m_btnShareSwitchCH03_Click(object sender, EventArgs e)
        {
            m_btnShareSwitchCH01.Checked = false;

            m_btnShareSwitchCH02.Checked = false;

            m_btnShareSwitchCH03.Checked = true;

            m_btnShareSwitchCH04.Checked = false;

            m_bShareRecordCH[0] = false; m_bShareRecordCH[1] = false; m_bShareRecordCH[2] = true; m_bShareRecordCH[3] = false;
        }

        private void m_btnShareSwitchCH04_Click(object sender, EventArgs e)
        {
            m_btnShareSwitchCH01.Checked = false;

            m_btnShareSwitchCH02.Checked = false;

            m_btnShareSwitchCH03.Checked = false;

            m_btnShareSwitchCH04.Checked = true;

            m_bShareRecordCH[0] = false; m_bShareRecordCH[1] = false; m_bShareRecordCH[2] = false; m_bShareRecordCH[3] = true;
        }
    }
}
