﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Runtime.InteropServices;

using QCAP.NET;

namespace NetReceiver
{
    public partial class Form1 : Form
    {
        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        public static extern void OutputDebugString(string message);

        [DllImport("kernel32.dll")]
        public static extern uint GetProfileInt(string lpAppName, string lpKeyName, int nDefault);

        [DllImport("kernel32.dll")]
        static extern uint GetProfileString(string lpAppName, string lpKeyName, string lpDefault, [Out] StringBuilder lpReturnedString, uint nSize);

        [DllImport("kernel32.dll")]
        public static extern bool WriteProfileString(string lpAppName, string lpKeyName, string lpString);

        public uint m_nProtocol = 0;

        public uint m_pNetworkReceiver = 0x00000000;

        public ulong m_nNetworkVideoStreamSize = 0;

        public ulong m_nNetworkAudioStreamSize = 0;

        public uint m_nNetworkVideoFrames = 0;

        public uint m_nNetworkAudioFrames = 0;

        public uint m_nNetworkVideoDecoderFrames = 0;

        public uint m_nNetworkAudioDecoderFrames = 0;

        public string m_strCurrentDir, m_strRecordPathName;

        // CALLBACK FUNCTION
        //             
        EXPORTS.PF_VIDEO_BROADCAST_CLIENT_CALLBACK m_pVideoBroadcastClientCB;

        EXPORTS.PF_AUDIO_BROADCAST_CLIENT_CALLBACK m_pAudioBroadcastClientCB;

        EXPORTS.PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK m_pVideoDecoderBroadcastClientCB;

        EXPORTS.PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK m_pAudioDecoderBroadcastClientCB;

        EXPORTS.ReturnOfCallbackEnum on_video_broadcast_client_callback(uint pClient, double dSampleTime, uint pStreamBuffer, uint nStreamBufferLen, uint bIsKeyFrame, uint pUserData)
        {
            m_nNetworkVideoStreamSize += nStreamBufferLen;

            m_nNetworkVideoFrames++;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        EXPORTS.ReturnOfCallbackEnum on_audio_broadcast_client_callback(uint pClient, double dSampleTime, uint pStreamBuffer, uint nStreamBufferLen, uint pUserData)
        {
            m_nNetworkAudioStreamSize += nStreamBufferLen;

            m_nNetworkAudioFrames++;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        EXPORTS.ReturnOfCallbackEnum on_video_decoder_broadcast_client_callback(uint pClient, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            m_nNetworkVideoDecoderFrames++;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        EXPORTS.ReturnOfCallbackEnum on_audio_decoder_broadcast_client_callback(uint pClient, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            m_nNetworkAudioDecoderFrames++;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            StringBuilder sb = new StringBuilder( 256 );            

            GetProfileString("DEFAULT", "URL", "rtsp://root:root@127.0.0.1:554/session0.mpg", sb, (uint)sb.Capacity);

            //m_editURL.Text = "rtsp://root:root@127.0.0.1:554/session0.mpg";

            m_editURL.Text = sb.ToString();

            m_nProtocol = GetProfileInt("DEFAULT", "PROTOCOL", 0);

            if (m_nProtocol == 0) { m_btnUDPProtocol.Checked = true; m_btnTCPProtocol.Checked = false; m_btnHTTPProtocol.Checked = false; }

            if (m_nProtocol == 1) { m_btnUDPProtocol.Checked = false; m_btnTCPProtocol.Checked = true; m_btnHTTPProtocol.Checked = false; }

            if (m_nProtocol == 2) { m_btnUDPProtocol.Checked = false; m_btnTCPProtocol.Checked = false; m_btnHTTPProtocol.Checked = true; }

            // GET CURRENT DIRECTORY
            //
            m_strCurrentDir = Directory.GetCurrentDirectory();

            m_strRecordPathName = m_strCurrentDir + "\\CH01.MP4";

            m_editRecordPath.Text = m_strRecordPathName;

            btnStart.Enabled = true;

            btnStop.Enabled = false;

            btnRecord.Enabled = true;

            btnStopRecord.Enabled = false;

            timer1.Enabled = true;    
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            // DISCONNECTION
            //
            btnStop_Click(sender, e);

            // UNINITIALIZE USER INTERFACE
            //
            timer1.Enabled = false;

            string strURL = m_editURL.Text;

            WriteProfileString("DEFAULT", "URL", strURL);            

            WriteProfileString("DEFAULT", "PROTOCOL", m_nProtocol.ToString());
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            string psz;

            ulong nNetworkVideoStreamSize = m_nNetworkVideoStreamSize / 1024;

            psz = @"VIDEO: " + nNetworkVideoStreamSize.ToString() + " KB (" + m_nNetworkVideoFrames.ToString() + " / " + m_nNetworkVideoDecoderFrames.ToString() + ")";

            m_statVideoInfo.Text = psz;

            ulong nNetworkAudioStreamSize = m_nNetworkAudioStreamSize / 1024;

            psz = @"AUDIO: " + nNetworkAudioStreamSize.ToString() + " KB (" + m_nNetworkAudioFrames.ToString() + " / " + m_nNetworkAudioDecoderFrames.ToString() + ")";

            m_statAudioInfo.Text = psz;           
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            btnStop_Click(sender, e);

            m_pNetworkReceiver = 0;

            m_nNetworkVideoStreamSize = 0;

            m_nNetworkAudioStreamSize = 0;

            m_nNetworkVideoFrames = 0;

            m_nNetworkAudioFrames = 0;

            m_nNetworkVideoDecoderFrames = 0;

            m_nNetworkAudioDecoderFrames = 0;

            string strURL = m_editURL.Text;

            EXPORTS.QCAP_CREATE_BROADCAST_CLIENT(0, ref strURL, ref m_pNetworkReceiver, (uint)m_statDisplayWindow.Handle.ToInt32(), 1, 0);

            m_pVideoBroadcastClientCB = new EXPORTS.PF_VIDEO_BROADCAST_CLIENT_CALLBACK(on_video_broadcast_client_callback);

            EXPORTS.QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK(m_pNetworkReceiver, m_pVideoBroadcastClientCB, 0);

            m_pAudioBroadcastClientCB = new EXPORTS.PF_AUDIO_BROADCAST_CLIENT_CALLBACK(on_audio_broadcast_client_callback);

            EXPORTS.QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK(m_pNetworkReceiver, m_pAudioBroadcastClientCB, 0);

            m_pVideoDecoderBroadcastClientCB = new EXPORTS.PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK(on_video_decoder_broadcast_client_callback);

            EXPORTS.QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK(m_pNetworkReceiver, m_pVideoDecoderBroadcastClientCB, 0);

            m_pAudioDecoderBroadcastClientCB = new EXPORTS.PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK(on_audio_decoder_broadcast_client_callback);

            EXPORTS.QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK(m_pNetworkReceiver, m_pAudioDecoderBroadcastClientCB, 0);

            if (m_nProtocol == 0) { EXPORTS.QCAP_START_BROADCAST_CLIENT(m_pNetworkReceiver, (uint)EXPORTS.BroadCastConnectionType.QCAP_BROADCAST_PROTOCOL_UDP); }

            if (m_nProtocol == 1) { EXPORTS.QCAP_START_BROADCAST_CLIENT(m_pNetworkReceiver, (uint)EXPORTS.BroadCastConnectionType.QCAP_BROADCAST_PROTOCOL_TCP); }

            if (m_nProtocol == 2) { EXPORTS.QCAP_START_BROADCAST_CLIENT(m_pNetworkReceiver, (uint)EXPORTS.BroadCastConnectionType.QCAP_BROADCAST_PROTOCOL_HTTP); }

            btnStart.Enabled = false;

            btnStop.Enabled = true;
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            if (m_pNetworkReceiver != 0)
            {
                EXPORTS.QCAP_STOP_BROADCAST_CLIENT(m_pNetworkReceiver);

                EXPORTS.QCAP_DESTROY_BROADCAST_CLIENT(m_pNetworkReceiver);

                m_pNetworkReceiver = 0;
            }

            btnStart.Enabled = true;

            btnStop.Enabled = false;
        }

        private void btnRecord_Click(object sender, EventArgs e)
        {
            btnStopRecord_Click(sender, e);

            if (m_pNetworkReceiver != 0)
            {
                EXPORTS.QCAP_START_BROADCAST_CLIENT_RECORD(m_pNetworkReceiver, ref m_strRecordPathName);                
            }

            btnRecord.Enabled = false;

            btnStopRecord.Enabled = true;            
        }

        private void btnStopRecord_Click(object sender, EventArgs e)
        {
            if (m_pNetworkReceiver != 0)
            {
                EXPORTS.QCAP_STOP_BROADCAST_CLIENT_RECORD(m_pNetworkReceiver);
            }

            btnRecord.Enabled = true;

            btnStopRecord.Enabled = false;            
        }

        private void m_nUDPProtocol_Click(object sender, EventArgs e)
        {
            m_btnUDPProtocol.Checked = true;

            m_btnTCPProtocol.Checked = false;

            m_btnHTTPProtocol.Checked = false;

            m_nProtocol = 0;
        }

        private void m_nTCPProtocol_Click(object sender, EventArgs e)
        {
            m_btnUDPProtocol.Checked = false;

            m_btnTCPProtocol.Checked = true;

            m_btnHTTPProtocol.Checked = false;

            m_nProtocol = 1;
        }

        private void m_nHTTPProtocol_Click(object sender, EventArgs e)
        {
            m_btnUDPProtocol.Checked = false;

            m_btnTCPProtocol.Checked = false;

            m_btnHTTPProtocol.Checked = true;

            m_nProtocol = 2;
        }
    }
}
