﻿
Imports QCAP.NET

Public Class MyRecordingDlg

    Declare Function OutputDebugString Lib "kernel32" Alias "OutputDebugStringA" (ByVal message As String)

    Public m_pMainForm As MySetupControl

    Public m_hCapDev() As UInt32 = {0, 0, 0, 0}

    Public m_strCurrentDir As String = ""

    Public m_bNoSignal1 As Boolean = True, m_bNoSignal2 As Boolean = True, m_bNoSignal3 As Boolean = True, m_bNoSignal4 As Boolean = True

    Public m_bIsRecord1_1 As Boolean = False, m_bIsRecord1_2 As Boolean = False, m_bIsRecord2_1 As Boolean = False, m_bIsRecord2_2 As Boolean = False

    Public m_bIsRecord3_1 As Boolean = False, m_bIsRecord3_2 As Boolean = False, m_bIsRecord4_1 As Boolean = False, m_bIsRecord4_2 As Boolean = False

    Public m_bCheckedAVI1_1 As Boolean = True, m_bCheckedAVI1_2 As Boolean = True, m_bCheckedAVI2_1 As Boolean = True, m_bCheckedAVI2_2 As Boolean = True

    Public m_bCheckedAVI3_1 As Boolean = True, m_bCheckedAVI3_2 As Boolean = True, m_bCheckedAVI4_1 As Boolean = True, m_bCheckedAVI4_2 As Boolean = True

    Public m_bCheckedMP41_1 As Boolean = False, m_bCheckedMP41_2 As Boolean = False, m_bCheckedMP42_1 As Boolean = False, m_bCheckedMP42_2 As Boolean = False

    Public m_bCheckedMP43_1 As Boolean = False, m_bCheckedMP43_2 As Boolean = False, m_bCheckedMP44_1 As Boolean = False, m_bCheckedMP44_2 As Boolean = False

    Public m_bCheckedFLV1_1 As Boolean = False, m_bCheckedFLV1_2 As Boolean = False, m_bCheckedFLV2_1 As Boolean = False, m_bCheckedFLV2_2 As Boolean = False

    Public m_bCheckedFLV3_1 As Boolean = False, m_bCheckedFLV3_2 As Boolean = False, m_bCheckedFLV4_1 As Boolean = False, m_bCheckedFLV4_2 As Boolean = False

    Public m_strAviName1_1 As String = "", m_strAviName1_2 As String = "", m_strAviName2_1 As String = "", m_strAviName2_2 As String = ""

    Public m_strAviName3_1 As String = "", m_strAviName3_2 As String = "", m_strAviName4_1 As String = "", m_strAviName4_2 As String = ""

    Private Sub MyRecordingDlg_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        ' GET CURRENT DIRECTORY
        '
        m_strCurrentDir = System.IO.Directory.GetCurrentDirectory()

        m_strAviName1_1 = m_strCurrentDir + "\CH01_1.AVI"

        m_strAviName1_2 = m_strCurrentDir + "\CH01_2.AVI"

        m_strAviName2_1 = m_strCurrentDir + "\CH02_1.AVI"

        m_strAviName2_2 = m_strCurrentDir + "\CH02_2.AVI"

        m_strAviName3_1 = m_strCurrentDir + "\CH03_1.AVI"

        m_strAviName3_2 = m_strCurrentDir + "\CH03_2.AVI"

        m_strAviName4_1 = m_strCurrentDir + "\CH04_1.AVI"

        m_strAviName4_2 = m_strCurrentDir + "\CH04_2.AVI"

        textBoxRecordAVI1_1.Text = m_strAviName1_1 : textBoxRecordAVI1_2.Text = m_strAviName1_2

        textBoxRecordAVI2_1.Text = m_strAviName2_1 : textBoxRecordAVI2_2.Text = m_strAviName2_2

        textBoxRecordAVI3_1.Text = m_strAviName3_1 : textBoxRecordAVI3_2.Text = m_strAviName3_2

        textBoxRecordAVI4_1.Text = m_strAviName4_1 : textBoxRecordAVI4_2.Text = m_strAviName4_2

        m_btnRecordStart1_1.Enabled = True : m_btnRecordStop1_1.Enabled = False

        m_btnRecordStart1_2.Enabled = True : m_btnRecordStop1_2.Enabled = False

        m_btnRecordStart2_1.Enabled = True : m_btnRecordStop2_1.Enabled = False

        m_btnRecordStart2_2.Enabled = True : m_btnRecordStop2_2.Enabled = False

        m_btnRecordStart3_1.Enabled = True : m_btnRecordStop3_1.Enabled = False

        m_btnRecordStart3_2.Enabled = True : m_btnRecordStop3_2.Enabled = False

        m_btnRecordStart4_1.Enabled = True : m_btnRecordStop4_1.Enabled = False

        m_btnRecordStart4_2.Enabled = True : m_btnRecordStop4_2.Enabled = False

    End Sub

    Private Sub MyRecordingDlg_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

        If m_hCapDev(0) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(0), 0) : m_bIsRecord1_1 = False

        End If

        If m_hCapDev(0) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(0), 1) : m_bIsRecord1_2 = False

        End If

        If m_hCapDev(1) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(1), 0) : m_bIsRecord2_1 = False

        End If

        If m_hCapDev(1) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(1), 1) : m_bIsRecord2_2 = False

        End If

        If m_hCapDev(2) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(2), 0) : m_bIsRecord3_1 = False

        End If

        If m_hCapDev(2) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(2), 1) : m_bIsRecord3_2 = False

        End If

        If m_hCapDev(3) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(3), 0) : m_bIsRecord4_1 = False

        End If

        If m_hCapDev(3) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(3), 1) : m_bIsRecord4_2 = False

        End If

    End Sub

    Private Sub MyRecordingDlg_Shown(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Shown

    End Sub

    Private Sub buttonOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles buttonOK.Click

        Hide()

    End Sub

    Private Sub m_btnRecordStart1_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStart1_1.Click

        m_hCapDev(0) = m_pMainForm.m_hCapDev1

        m_btnRecordStart1_1.Enabled = False

        m_btnRecordStop1_1.Enabled = True

        If m_hCapDev(0) <> 0 Then

            If m_bCheckedAVI1_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(0), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM)

            End If

            If m_bCheckedMP41_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(0), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            If m_bCheckedFLV1_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(0), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev(0), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0, EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_OFF)

            EXPORTS.QCAP_START_RECORD(m_hCapDev(0), 0, m_strAviName1_1)

            m_bIsRecord1_1 = True

        End If

    End Sub

    Private Sub m_btnRecordStop1_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStop1_1.Click

        m_hCapDev(0) = m_pMainForm.m_hCapDev1

        m_btnRecordStart1_1.Enabled = True

        m_btnRecordStop1_1.Enabled = False

        If m_hCapDev(0) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(0), 0)

            m_bIsRecord1_1 = False

        End If

    End Sub

    Private Sub m_btnRecordStart1_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStart1_2.Click

        m_hCapDev(0) = m_pMainForm.m_hCapDev1

        m_btnRecordStart1_2.Enabled = False

        m_btnRecordStop1_2.Enabled = True

        If m_hCapDev(0) <> 0 Then

            If m_bCheckedAVI1_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(0), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM)

            End If

            If m_bCheckedMP41_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(0), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            If m_bCheckedFLV1_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(0), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev(0), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0, EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_1_4)

            EXPORTS.QCAP_START_RECORD(m_hCapDev(0), 0, m_strAviName1_2)

            m_bIsRecord1_2 = True

        End If

    End Sub

    Private Sub m_btnRecordStop1_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStop1_2.Click

        m_hCapDev(0) = m_pMainForm.m_hCapDev1

        m_btnRecordStart1_2.Enabled = True

        m_btnRecordStop1_2.Enabled = False

        If m_hCapDev(0) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(0), 1)

            m_bIsRecord1_2 = False

        End If

    End Sub

    Private Sub m_btnRecordStart2_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStart2_1.Click

        m_hCapDev(1) = m_pMainForm.m_hCapDev2

        m_btnRecordStart2_1.Enabled = False

        m_btnRecordStop2_1.Enabled = True

        If m_hCapDev(0) <> 0 Then

            If m_bCheckedAVI2_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(1), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM)

            End If

            If m_bCheckedMP42_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(1), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            If m_bCheckedFLV2_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(1), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev(1), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0, EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_OFF)

            EXPORTS.QCAP_START_RECORD(m_hCapDev(1), 0, m_strAviName2_1)

            m_bIsRecord2_1 = True

        End If

    End Sub

    Private Sub m_btnRecordStop2_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStop2_1.Click

        m_hCapDev(1) = m_pMainForm.m_hCapDev2

        m_btnRecordStart2_1.Enabled = True

        m_btnRecordStop2_1.Enabled = False

        If m_hCapDev(1) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(1), 0)

            m_bIsRecord2_1 = False

        End If

    End Sub

    Private Sub m_btnRecordStart2_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStart2_2.Click

        m_hCapDev(1) = m_pMainForm.m_hCapDev2

        m_btnRecordStart2_2.Enabled = False

        m_btnRecordStop2_2.Enabled = True

        If m_hCapDev(1) <> 0 Then

            If m_bCheckedAVI2_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(1), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM)

            End If

            If m_bCheckedMP42_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(1), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            If m_bCheckedFLV2_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(1), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

        End If

        EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev(1), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0, EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_1_4)

        EXPORTS.QCAP_START_RECORD(m_hCapDev(1), 1, m_strAviName2_2)

        m_bIsRecord2_2 = True

    End Sub

    Private Sub m_btnRecordStop2_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStop2_2.Click

        m_hCapDev(1) = m_pMainForm.m_hCapDev2

        m_btnRecordStart2_2.Enabled = True

        m_btnRecordStop2_2.Enabled = False

        If m_hCapDev(1) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(1), 1)

            m_bIsRecord2_2 = False

        End If

    End Sub

    Private Sub m_btnRecordStart3_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStart3_1.Click

        m_hCapDev(2) = m_pMainForm.m_hCapDev3

        m_btnRecordStart3_1.Enabled = False

        m_btnRecordStop3_1.Enabled = True

        If m_hCapDev(2) <> 0 Then

            If m_bCheckedAVI3_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(2), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM)

            End If

            If m_bCheckedMP43_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(2), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            If m_bCheckedFLV3_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(2), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev(2), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0, EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_OFF)

            EXPORTS.QCAP_START_RECORD(m_hCapDev(2), 0, m_strAviName3_1)

            m_bIsRecord3_1 = True

        End If

    End Sub

    Private Sub m_btnRecordStop3_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStop3_1.Click

        m_hCapDev(2) = m_pMainForm.m_hCapDev3

        m_btnRecordStart3_1.Enabled = True

        m_btnRecordStop3_1.Enabled = False

        If m_hCapDev(2) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(2), 0)

            m_bIsRecord3_1 = False

        End If

    End Sub

    Private Sub m_btnRecordStart3_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStart3_2.Click

        m_hCapDev(2) = m_pMainForm.m_hCapDev3

        m_btnRecordStart3_2.Enabled = False

        m_btnRecordStop3_2.Enabled = True

        If m_hCapDev(2) <> 0 Then

            If m_bCheckedAVI3_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(2), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM)

            End If

            If m_bCheckedMP43_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(2), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            If m_bCheckedFLV3_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(2), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev(2), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0, EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_1_4)

            EXPORTS.QCAP_START_RECORD(m_hCapDev(2), 1, m_strAviName3_2)

            m_bIsRecord3_2 = True

        End If

    End Sub

    Private Sub m_btnRecordStop3_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStop3_2.Click

        m_hCapDev(2) = m_pMainForm.m_hCapDev3

        m_btnRecordStart3_2.Enabled = True

        m_btnRecordStop3_2.Enabled = False

        If m_hCapDev(2) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(2), 1)

            m_bIsRecord3_1 = False

        End If

    End Sub

    Private Sub m_btnRecordStart4_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStart4_1.Click

        m_hCapDev(3) = m_pMainForm.m_hCapDev4

        m_btnRecordStart4_1.Enabled = False

        m_btnRecordStop4_1.Enabled = True

        If m_hCapDev(3) <> 0 Then

            If m_bCheckedAVI4_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(3), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM)

            End If

            If m_bCheckedMP44_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(3), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            If m_bCheckedFLV4_1 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(3), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev(3), 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0, EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_OFF)

            EXPORTS.QCAP_START_RECORD(m_hCapDev(3), 0, m_strAviName4_1)

            m_bIsRecord4_1 = True

        End If

    End Sub

    Private Sub m_btnRecordStop4_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStop4_1.Click

        m_hCapDev(3) = m_pMainForm.m_hCapDev4

        m_btnRecordStart4_1.Enabled = True

        m_btnRecordStop4_1.Enabled = False

        If m_hCapDev(3) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(3), 0)

            m_bIsRecord4_1 = False

        End If

    End Sub

    Private Sub m_btnRecordStart4_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStart4_2.Click

        m_hCapDev(3) = m_pMainForm.m_hCapDev4

        m_btnRecordStart4_2.Enabled = False

        m_btnRecordStop4_2.Enabled = True

        If m_hCapDev(3) <> 0 Then

            If m_bCheckedAVI4_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(3), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM)

            End If

            If m_bCheckedMP44_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(3), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            If m_bCheckedFLV4_2 = True Then

                EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev(3), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)

            End If

            EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev(3), 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0, EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_1_4)

            EXPORTS.QCAP_START_RECORD(m_hCapDev(3), 1, m_strAviName4_2)

            m_bIsRecord4_2 = True

        End If

    End Sub

    Private Sub m_btnRecordStop4_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRecordStop4_2.Click

        m_hCapDev(3) = m_pMainForm.m_hCapDev4

        m_btnRecordStart4_2.Enabled = True

        m_btnRecordStop4_2.Enabled = False

        If m_hCapDev(3) <> 0 Then

            EXPORTS.QCAP_STOP_RECORD(m_hCapDev(3), 1)

            m_bIsRecord4_2 = False

        End If

    End Sub

    Private Sub timerCheckSignal_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles timerCheckSignal.Tick

        m_hCapDev(0) = m_pMainForm.m_hCapDev1

        m_hCapDev(1) = m_pMainForm.m_hCapDev2

        m_hCapDev(2) = m_pMainForm.m_hCapDev3

        m_hCapDev(3) = m_pMainForm.m_hCapDev4

        If m_hCapDev(0) <> 0 Then

            If m_bIsRecord1_1 And m_bNoSignal1 Then

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev(0), 0) : m_bIsRecord1_1 = False

            End If

            If m_bIsRecord1_2 And m_bNoSignal1 Then

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev(0), 1) : m_bIsRecord1_2 = False

            End If

        End If

        If m_hCapDev(1) <> 0 Then

            If m_bIsRecord2_1 And m_bNoSignal2 Then

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev(1), 0) : m_bIsRecord2_1 = False

            End If

            If m_bIsRecord2_2 And m_bNoSignal2 Then

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev(1), 1) : m_bIsRecord2_2 = False

            End If

        End If

        If m_hCapDev(2) <> 0 Then

            If m_bIsRecord3_1 And m_bNoSignal3 Then

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev(2), 0) : m_bIsRecord3_1 = False

            End If

            If m_bIsRecord3_2 And m_bNoSignal3 Then

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev(2), 1) : m_bIsRecord3_2 = False

            End If

        End If

        If m_hCapDev(3) <> 0 Then

            If m_bIsRecord4_1 And m_bNoSignal4 Then

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev(3), 0) : m_bIsRecord4_1 = False

            End If

            If m_bIsRecord4_2 And m_bNoSignal4 Then

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev(3), 1) : m_bIsRecord4_2 = False

            End If

        End If

    End Sub

    Private Sub m_checkAVI1_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkAVI1_1.Click

        m_checkAVI1_1.Checked = True

        m_checkMP41_1.Checked = False

        m_checkFLV1_1.Checked = False

        m_bCheckedAVI1_1 = True

        m_bCheckedMP41_1 = False

        m_bCheckedFLV1_1 = False

        m_strAviName1_1 = m_strAviName1_1.Replace(".MP4", ".AVI")

        m_strAviName1_1 = m_strAviName1_1.Replace(".FLV", ".AVI")

        textBoxRecordAVI1_1.Text = m_strAviName1_1

    End Sub

    Private Sub m_checkAVI1_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkAVI1_2.Click

        m_checkAVI1_2.Checked = True

        m_checkMP41_2.Checked = False

        m_checkFLV1_2.Checked = False

        m_bCheckedAVI1_2 = True

        m_bCheckedMP41_2 = False

        m_bCheckedFLV1_2 = False

        m_strAviName1_2 = m_strAviName1_2.Replace(".MP4", ".AVI")

        m_strAviName1_2 = m_strAviName1_2.Replace(".FLV", ".AVI")

        textBoxRecordAVI1_2.Text = m_strAviName1_2

    End Sub

    Private Sub m_checkAVI2_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkAVI2_1.Click

        m_checkAVI2_1.Checked = True

        m_checkMP42_1.Checked = False

        m_checkFLV2_1.Checked = False

        m_bCheckedAVI2_1 = True

        m_bCheckedMP42_1 = False

        m_bCheckedFLV2_1 = False

        m_strAviName2_1 = m_strAviName2_1.Replace(".MP4", ".AVI")

        m_strAviName2_1 = m_strAviName2_1.Replace(".FLV", ".AVI")

        textBoxRecordAVI2_1.Text = m_strAviName2_1

    End Sub

    Private Sub m_checkAVI2_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkAVI2_2.Click

        m_checkAVI2_2.Checked = True

        m_checkMP42_2.Checked = False

        m_checkFLV2_2.Checked = False

        m_bCheckedAVI2_2 = True

        m_bCheckedMP42_2 = False

        m_bCheckedFLV2_2 = False

        m_strAviName2_2 = m_strAviName2_2.Replace(".MP4", ".AVI")

        m_strAviName2_2 = m_strAviName2_2.Replace(".FLV", ".AVI")

        textBoxRecordAVI2_2.Text = m_strAviName2_2

    End Sub

    Private Sub m_checkAVI3_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkAVI3_1.Click

        m_checkAVI3_1.Checked = True

        m_checkMP43_1.Checked = False

        m_checkFLV3_1.Checked = False

        m_bCheckedAVI3_1 = True

        m_bCheckedMP43_1 = False

        m_bCheckedFLV3_1 = False

        m_strAviName3_1 = m_strAviName3_1.Replace(".MP4", ".AVI")

        m_strAviName3_1 = m_strAviName3_1.Replace(".FLV", ".AVI")

        textBoxRecordAVI3_1.Text = m_strAviName3_1

    End Sub

    Private Sub m_checkAVI3_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkAVI3_2.Click

        m_checkAVI3_2.Checked = True

        m_checkMP43_2.Checked = False

        m_checkFLV3_2.Checked = False

        m_bCheckedAVI3_2 = True

        m_bCheckedMP43_2 = False

        m_bCheckedFLV3_2 = False

        m_strAviName3_2 = m_strAviName3_2.Replace(".MP4", ".AVI")

        m_strAviName3_2 = m_strAviName3_2.Replace(".FLV", ".AVI")

        textBoxRecordAVI3_2.Text = m_strAviName3_2

    End Sub

    Private Sub m_checkAVI4_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkAVI4_1.Click

        m_checkAVI4_1.Checked = True

        m_checkMP44_1.Checked = False

        m_checkFLV4_1.Checked = False

        m_bCheckedAVI4_1 = True

        m_bCheckedMP44_1 = False

        m_bCheckedFLV4_1 = False

        m_strAviName4_1 = m_strAviName4_1.Replace(".MP4", ".AVI")

        m_strAviName4_1 = m_strAviName4_1.Replace(".FLV", ".AVI")

        textBoxRecordAVI4_1.Text = m_strAviName4_1

    End Sub

    Private Sub m_checkAVI4_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkAVI4_2.Click

        m_checkAVI4_2.Checked = True

        m_checkMP44_2.Checked = False

        m_checkFLV4_2.Checked = False

        m_bCheckedAVI4_2 = True

        m_bCheckedMP44_2 = False

        m_bCheckedFLV4_2 = False

        m_strAviName4_2 = m_strAviName4_2.Replace(".MP4", ".AVI")

        m_strAviName4_2 = m_strAviName4_2.Replace(".FLV", ".AVI")

        textBoxRecordAVI4_2.Text = m_strAviName4_2

    End Sub

    Private Sub m_checkMP41_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkMP41_1.Click

        m_checkAVI1_1.Checked = False

        m_checkMP41_1.Checked = True

        m_checkFLV1_1.Checked = False

        m_bCheckedAVI1_1 = False

        m_bCheckedMP41_1 = True

        m_bCheckedFLV1_1 = False

        m_strAviName1_1 = m_strAviName1_1.Replace(".AVI", ".MP4")

        m_strAviName1_1 = m_strAviName1_1.Replace(".FLV", ".MP4")

        textBoxRecordAVI1_1.Text = m_strAviName1_1

    End Sub

    Private Sub m_checkMP41_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkMP41_2.Click

        m_checkAVI1_2.Checked = False

        m_checkMP41_2.Checked = True

        m_checkFLV1_2.Checked = False

        m_bCheckedAVI1_2 = False

        m_bCheckedMP41_2 = True

        m_bCheckedFLV1_2 = False

        m_strAviName1_2 = m_strAviName1_2.Replace(".AVI", ".MP4")

        m_strAviName1_2 = m_strAviName1_2.Replace(".FLV", ".MP4")

        textBoxRecordAVI1_2.Text = m_strAviName1_2

    End Sub

    Private Sub m_checkMP42_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkMP42_1.Click

        m_checkAVI2_1.Checked = False

        m_checkMP42_1.Checked = True

        m_checkFLV2_1.Checked = False

        m_bCheckedAVI2_1 = False

        m_bCheckedMP42_1 = True

        m_bCheckedFLV2_1 = False

        m_strAviName2_1 = m_strAviName2_1.Replace(".AVI", ".MP4")

        m_strAviName2_1 = m_strAviName2_1.Replace(".FLV", ".MP4")

        textBoxRecordAVI2_1.Text = m_strAviName2_1

    End Sub

    Private Sub m_checkMP42_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkMP42_2.Click

        m_checkAVI2_2.Checked = False

        m_checkMP42_2.Checked = True

        m_checkFLV2_2.Checked = False

        m_bCheckedAVI2_2 = False

        m_bCheckedMP42_2 = True

        m_bCheckedFLV2_2 = False

        m_strAviName2_2 = m_strAviName2_2.Replace(".AVI", ".MP4")

        m_strAviName2_2 = m_strAviName2_2.Replace(".FLV", ".MP4")

        textBoxRecordAVI2_2.Text = m_strAviName2_2

    End Sub

    Private Sub m_checkMP43_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkMP43_1.Click

        m_checkAVI3_1.Checked = False

        m_checkMP43_1.Checked = True

        m_checkFLV3_1.Checked = False

        m_bCheckedAVI3_1 = False

        m_bCheckedMP43_1 = True

        m_bCheckedFLV3_1 = False

        m_strAviName3_1 = m_strAviName3_1.Replace(".AVI", ".MP4")

        m_strAviName3_1 = m_strAviName3_1.Replace(".FLV", ".MP4")

        textBoxRecordAVI3_1.Text = m_strAviName3_1

    End Sub

    Private Sub m_checkMP43_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkMP43_2.Click

        m_checkAVI3_2.Checked = False

        m_checkMP43_2.Checked = True

        m_checkFLV3_2.Checked = False

        m_bCheckedAVI3_2 = False

        m_bCheckedMP43_2 = True

        m_bCheckedFLV3_2 = False

        m_strAviName3_2 = m_strAviName3_2.Replace(".AVI", ".MP4")

        m_strAviName3_2 = m_strAviName3_2.Replace(".FLV", ".MP4")

        textBoxRecordAVI3_2.Text = m_strAviName3_2

    End Sub

    Private Sub m_checkMP44_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkMP44_1.Click

        m_checkAVI4_1.Checked = False

        m_checkMP44_1.Checked = True

        m_checkFLV4_1.Checked = False

        m_bCheckedAVI4_1 = False

        m_bCheckedMP44_1 = True

        m_bCheckedFLV4_1 = False

        m_strAviName4_1 = m_strAviName4_1.Replace(".AVI", ".MP4")

        m_strAviName4_1 = m_strAviName4_1.Replace(".FLV", ".MP4")

        textBoxRecordAVI4_1.Text = m_strAviName4_1

    End Sub

    Private Sub m_checkMP44_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkMP44_2.Click

        m_checkAVI4_2.Checked = False

        m_checkMP44_2.Checked = True

        m_checkFLV4_2.Checked = False

        m_bCheckedAVI4_2 = False

        m_bCheckedMP44_2 = True

        m_bCheckedFLV4_2 = False

        m_strAviName4_2 = m_strAviName4_2.Replace(".AVI", ".MP4")

        m_strAviName4_2 = m_strAviName4_2.Replace(".FLV", ".MP4")

        textBoxRecordAVI4_2.Text = m_strAviName4_2

    End Sub

    Private Sub m_checkFLV1_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkFLV1_1.Click

        m_checkAVI1_1.Checked = False

        m_checkMP41_1.Checked = False

        m_checkFLV1_1.Checked = True

        m_bCheckedAVI1_1 = False

        m_bCheckedMP41_1 = False

        m_bCheckedFLV1_1 = True

        m_strAviName1_1 = m_strAviName1_1.Replace(".AVI", ".FLV")

        m_strAviName1_1 = m_strAviName1_1.Replace(".MP4", ".FLV")

        textBoxRecordAVI1_1.Text = m_strAviName1_1

    End Sub

    Private Sub m_checkFLV1_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkFLV1_2.Click

        m_checkAVI1_2.Checked = False

        m_checkMP41_2.Checked = False

        m_checkFLV1_2.Checked = True

        m_bCheckedAVI1_2 = False

        m_bCheckedMP41_2 = False

        m_bCheckedFLV1_2 = True

        m_strAviName1_2 = m_strAviName1_2.Replace(".AVI", ".FLV")

        m_strAviName1_2 = m_strAviName1_2.Replace(".MP4", ".FLV")

        textBoxRecordAVI1_2.Text = m_strAviName1_2

    End Sub

    Private Sub m_checkFLV2_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkFLV2_1.Click

        m_checkAVI2_1.Checked = False

        m_checkMP42_1.Checked = False

        m_checkFLV2_1.Checked = True

        m_bCheckedAVI2_1 = False

        m_bCheckedMP42_1 = False

        m_bCheckedFLV2_1 = True

        m_strAviName2_1 = m_strAviName2_1.Replace(".AVI", ".FLV")

        m_strAviName2_1 = m_strAviName2_1.Replace(".MP4", ".FLV")

        textBoxRecordAVI2_1.Text = m_strAviName2_1

    End Sub

    Private Sub m_checkFLV2_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkFLV2_2.Click

        m_checkAVI2_2.Checked = False

        m_checkMP42_2.Checked = False

        m_checkFLV2_2.Checked = True

        m_bCheckedAVI2_2 = False

        m_bCheckedMP42_2 = False

        m_bCheckedFLV2_2 = True

        m_strAviName2_2 = m_strAviName2_2.Replace(".AVI", ".FLV")

        m_strAviName2_2 = m_strAviName2_2.Replace(".MP4", ".FLV")

        textBoxRecordAVI2_2.Text = m_strAviName2_2

    End Sub

    Private Sub m_checkFLV3_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkFLV3_1.Click

        m_checkAVI3_1.Checked = False

        m_checkMP43_1.Checked = False

        m_checkFLV3_1.Checked = True

        m_bCheckedAVI3_1 = False

        m_bCheckedMP43_1 = False

        m_bCheckedFLV3_1 = True

        m_strAviName3_1 = m_strAviName3_1.Replace(".AVI", ".FLV")

        m_strAviName3_1 = m_strAviName3_1.Replace(".MP4", ".FLV")

        textBoxRecordAVI3_1.Text = m_strAviName3_1

    End Sub

    Private Sub m_checkFLV3_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkFLV3_2.Click

        m_checkAVI3_2.Checked = False

        m_checkMP43_2.Checked = False

        m_checkFLV3_2.Checked = True

        m_bCheckedAVI3_2 = False

        m_bCheckedMP43_2 = False

        m_bCheckedFLV3_2 = True

        m_strAviName3_2 = m_strAviName3_2.Replace(".AVI", ".FLV")

        m_strAviName3_2 = m_strAviName3_2.Replace(".MP4", ".FLV")

        textBoxRecordAVI3_2.Text = m_strAviName3_2

    End Sub

    Private Sub m_checkFLV4_1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkFLV4_1.Click

        m_checkAVI4_1.Checked = False

        m_checkMP44_1.Checked = False

        m_checkFLV4_1.Checked = True

        m_bCheckedAVI4_1 = False

        m_bCheckedMP44_1 = False

        m_bCheckedFLV4_1 = True

        m_strAviName4_1 = m_strAviName4_1.Replace(".AVI", ".FLV")

        m_strAviName4_1 = m_strAviName4_1.Replace(".MP4", ".FLV")

        textBoxRecordAVI4_1.Text = m_strAviName4_1

    End Sub

    Private Sub m_checkFLV4_2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkFLV4_2.Click

        m_checkAVI4_2.Checked = False

        m_checkMP44_2.Checked = False

        m_checkFLV4_2.Checked = True

        m_bCheckedAVI4_2 = False

        m_bCheckedMP44_2 = False

        m_bCheckedFLV4_2 = True

        m_strAviName4_2 = m_strAviName4_2.Replace(".AVI", ".FLV")

        m_strAviName4_2 = m_strAviName4_2.Replace(".MP4", ".FLV")

        textBoxRecordAVI4_2.Text = m_strAviName4_2

    End Sub

End Class