﻿Imports QCAP.NET

Public Class MyStreamingControl

    Declare Function OutputDebugString Lib "kernel32" Alias "OutputDebugStringA" (ByVal message As String)

    Public m_hCapDev() As UInt32 = {0, 0, 0, 0}

    Public m_bSupportGPU As Boolean = False

    Public m_hRtspCapDev As UInt32 = 0 ' RTSP STREAM CAPTURE DEVICE

    Public m_nVideoWidth As UInt32 = 1920

    Public m_nVideoHeight As UInt32 = 1080

    Public m_nVideoFrameRate As UInt32 = 60

    Public m_pMainForm As MySetupControl

    Private Sub MyStreamingControl_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        m_btnStartStreaming.Enabled = True

        m_btnStopStreaming.Enabled = False

    End Sub

    Private Sub MyStreamingControl_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

    End Sub

    Private Sub buttonOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles buttonOK.Click

        Hide()

    End Sub

    Private Sub m_btnStartStreaming_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnStartStreaming.Click

        m_bSupportGPU = m_checkRtspGPU.Checked

        ' CREATE RTSP SERVER
        '
        Dim strAccount As String = "root"

        Dim strPassword As String = "root"

        EXPORTS.QCAP_CREATE_BROADCAST_RTSP_SERVER(0, 4, m_hRtspCapDev, strAccount, strPassword, 554)

        If m_bSupportGPU = True Then

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, &H32315659, m_nVideoWidth / 2, m_nVideoHeight / 2, m_nVideoFrameRate, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0)

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, &H32315659, m_nVideoWidth / 2, m_nVideoHeight / 2, m_nVideoFrameRate, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0)

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 2, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, &H32315659, m_nVideoWidth / 2, m_nVideoHeight / 2, m_nVideoFrameRate, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0)

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 3, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, &H32315659, m_nVideoWidth / 2, m_nVideoHeight / 2, m_nVideoFrameRate, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0)

        Else

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, &H32315659, m_nVideoWidth / 2, m_nVideoHeight / 2, m_nVideoFrameRate, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0)

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, &H32315659, m_nVideoWidth / 2, m_nVideoHeight / 2, m_nVideoFrameRate, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0)

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 2, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, &H32315659, m_nVideoWidth / 2, m_nVideoHeight / 2, m_nVideoFrameRate, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0)

            EXPORTS.QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 3, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, &H32315659, m_nVideoWidth / 2, m_nVideoHeight / 2, m_nVideoFrameRate, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12582912, 30, 0, 0)

        End If

        EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 0, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM, 2, 16, 48000, 100)

        EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 1, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM, 2, 16, 48000, 100)

        EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 2, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM, 2, 16, 48000, 100)

        EXPORTS.QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY(m_hRtspCapDev, 3, EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM, 2, 16, 48000, 100)

        If m_hRtspCapDev <> 0 Then

            m_pMainForm.m_pMainForm.m_bIsStreaming = True

            m_pMainForm.m_pMainForm.m_hRtspCapDev = m_hRtspCapDev


        End If

        EXPORTS.QCAP_START_BROADCAST_SERVER(m_hRtspCapDev)

        m_btnStartStreaming.Enabled = False

        m_btnStopStreaming.Enabled = True

    End Sub

    Private Sub m_btnStopStreaming_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnStopStreaming.Click

        m_pMainForm.m_pMainForm.m_bIsStreaming = False

        m_pMainForm.m_pMainForm.m_hRtspCapDev = 0

        ' STOP RTSP STREAMING
        '            
        EXPORTS.QCAP_STOP_BROADCAST_SERVER(m_hRtspCapDev)

        EXPORTS.QCAP_DESTROY_BROADCAST_SERVER(m_hRtspCapDev)

        m_btnStartStreaming.Enabled = True

        m_btnStopStreaming.Enabled = False

    End Sub

End Class